﻿/*	VER:	1.2
1.2:		(pokemon font workarounds)	  ~ -> Tilde		" -> Quote

USAGE:
	#include "functions/getKeyName.as"
	spaceName = getKeyName(32);		// "Space"
*/
getKeyName = function()
{
	var code = Number(arguments[0]);
	// handle non-visible characters
	switch(code)
	{
		case 8:		// backspace
			var outputString = "Backspace";
		break;
		case 9:		// tab
			var outputString = "Tab";
		break;
		
		case 13:		// Enter
			var outputString = "Enter";
		break;
		
		case 16:		// Shift
			var outputString = "Shift";
		break;
		case 17:		// Control
			var outputString = "Ctrl";
		break;
		
		case 19:		// Pause
			var outputString = "Pause / Break";
		break;
		case 20:		// Caps Lock
			var outputString = "CAPS Lock";
		break;
		
		case 27:		// Esc
			var outputString = "Esc";
		break;
		
		case 32:		// Space
			var outputString = "Space";
		break;
		case 33:		// Page up
			var outputString = "Page Up";
		break;
		case 34:		// Page down
			var outputString = "Page Down";
		break;
		case 35:		// End
			var outputString = "End";
		break;
		case 36:		// Home
			var outputString = "Home";
		break;
		case 37:		// left	
			var outputString = "arrow: LEFT";
		break;
		case 38:		// up	
			var outputString = "arrow: UP";
		break;
		case 39:		// right	
			var outputString = "arrow: RIGHT";
		break;
		case 40:		// down	
			var outputString = "arrow: DOWN";
		break;
		
		case 45:		// Insert
			var outputString = "Insert";
		break;
		case 46:		// Del
			var outputString = "Delete";
		break;
		
		case 91:		// Windows key
			var outputString = "Win";
		break;
		case 93:		// Contextual menu key
			var outputString = "Contextual";
		break;
		
		case 96:		// 0		(num pad)
			var outputString = "num pad 0";
		break;
		case 97:		// 1		(num pad)
			var outputString = "num pad 1";
		break;
		case 98:		// 2		(num pad)
			var outputString = "num pad 2";
		break;
		case 99:		// 3		(num pad)
			var outputString = "num pad 3";
		break;
		case 100:		// 4		(num pad)
			var outputString = "num pad 4";
		break;
		case 101:		// 5		(num pad)
			var outputString = "num pad 5";
		break;
		case 102:		// 6		(num pad)
			var outputString = "num pad 6";
		break;
		case 103:		// 7		(num pad)
			var outputString = "num pad 7";
		break;
		case 104:		// 8		(num pad)
			var outputString = "num pad 8";
		break;
		case 105:		// 9		(num pad)
			var outputString = "num pad 9";
		break;
		case 106:		// *		(num pad)
			var outputString = "num pad *";
		break;
		case 107:		// +		(num pad)
			var outputString = "num pad +";
		break;
		
		case 109:		// -		(num pad)
			var outputString = "num pad -";
		break;
		case 110:		// .		(num pad)
			var outputString = "num pad .";
		break;
		case 111:		// /		(num pad)
			var outputString = "num pad /";
		break;
		
		case 112:		// F1
			var outputString = "F1";
		break;
		case 113:		// F2
			var outputString = "";
		break;
		case 114:		// F3
			var outputString = "";
		break;
		case 115:		// F4
			var outputString = "F4";
		break;
		case 116:		// F5
			var outputString = "F5";
		break;
		case 117:		// F6
			var outputString = "F6";
		break;
		case 118:		// F7
			var outputString = "F7";
		break;
		case 119:		// F8
			var outputString = "F8";
		break;
		case 120:		// F9
			var outputString = "F9";
		break;
		case 121:		// F10				(this is unusable)
			var outputString = "F10";
		break;
		case 122:		// F11
			var outputString = "F11";
		break;
		case 123:		// F12
			var outputString = "F12";
		break;
		case 124:		// F13
			var outputString = "F13";
		break;
		case 125:		// F14
			var outputString = "F14";
		break;
		case 126:		// F15
			var outputString = "F15";
		break;
		
		case 144:		// Num Lock
			var outputString = "Num Lock";
		break;
		case 145:		// Scroll Lock
			var outputString = "Scroll Lock";
		break;
		
		
		case 186:		// ;
			var outputString = ";";
		break;
		case 187:		// =
			var outputString = "=";
		break;
		case 188:		// <
			var outputString = "<";
		break;
		case 189:		// -
			var outputString = "-";
		break;
		case 190:		// >
			var outputString = ">";
		break;
		case 191:		// /
			var outputString = "/";
		break;
		case 192:		// ~
			var outputString = "Tilde";		// ~
		break;
		
		case 219:		// [
			var outputString = "[";
		break;
		case 220:		// \
			var outputString = "\\";
		break;
		case 221:		// ]
			var outputString = "]";
		break;
		case 222:		// "
			var outputString = 'Quote';			// "
		break;
		
		
		default:
			var outputString = String.fromCharCode( code );
	}// switch:  key code
	
	return outputString;
}// getKeyName()